<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Http\Request;
use App\Http\Response;
use App\Http\HttpException;
use App\Security\ApiAuth;
use App\Services\TipoCambioService;

class TipoCambioController
{
    /**
     * GET /api/v1/indicadores/tc[?refresh=1]
     *
     * Devuelve tipo de cambio actual de USD y EUR.
     */
    public function actual(Request $request): void
    {
        ApiAuth::requireValidKey($request);

        $forceRefresh = isset($_GET['refresh']) && $_GET['refresh'] === '1';

        $tc = TipoCambioService::obtenerActual($forceRefresh);

        if ($tc === null) {
            throw new HttpException('No se pudo obtener el tipo de cambio', 503);
        }

        Response::json([
            'ok'    => true,
            'fecha' => $tc['fecha'],
            'usd'   => $tc['usd'],
            'eur'   => $tc['eur'],
        ]);
    }
}
