<?php
declare(strict_types=1);

use App\Core\Autoloader;
use App\Core\Config;

// Configuración de errores (en producción mantener display_errors en 0)
ini_set('display_errors', '0');
ini_set('display_startup_errors', '0');
error_reporting(E_ALL);

// Autoloader propio del proyecto
require __DIR__ . '/Core/Autoloader.php';
Autoloader::register();

// Configuración central del proyecto
require __DIR__ . '/Core/Config.php';

/**
 * FIX para la librería stibenamm/firma-xades-cr
 *
 * En algunos entornos (Linux con sistema de archivos case sensitive),
 * el autoload PSR-4 busca:
 *
 *   Stibenamm\FirmaXadesCR\Contracts\FirmaXades
 *   Stibenamm\FirmaXadesCR\Overrides\XMLSecurityDSig
 *
 * mapeando a:
 *
 *   src/Contracts/FirmaXades.php
 *   src/Overrides/XMLSecurityDSig.php
 *
 * Pero el paquete trae los archivos dentro de carpetas en minúscula:
 *
 *   src/contracts/FirmaXades.php
 *   src/overrides/XMLSecurityDSig.php
 *
 * Eso provoca errores tipo:
 *
 *   Interface "Stibenamm\FirmaXadesCR\Contracts\FirmaXades" not found
 *   Class "Stibenamm\FirmaXadesCR\Overrides\XMLSecurityDSig" not found
 *
 * Para evitarlo, cargamos manualmente esos archivos ANTES de que se usen.
 *
 * NOTA: BASE_PATH se define en public/index.php
 */
if (defined('BASE_PATH')) {
    $firmaBaseDir = BASE_PATH . '/vendor/stibenamm/firma-xades-cr/src';

    // 1) Interfaz FirmaXades
    $firmaXadesInterfacePath = $firmaBaseDir . '/contracts/FirmaXades.php';
    if (
        is_file($firmaXadesInterfacePath)
        && !interface_exists(\Stibenamm\FirmaXadesCR\Contracts\FirmaXades::class, false)
    ) {
        require_once $firmaXadesInterfacePath;
    }

    // 2) Clase override XMLSecurityDSig
    $xmlSecOverridePath = $firmaBaseDir . '/overrides/XMLSecurityDSig.php';
    if (
        is_file($xmlSecOverridePath)
        && !class_exists(\Stibenamm\FirmaXadesCR\Overrides\XMLSecurityDSig::class, false)
    ) {
        require_once $xmlSecOverridePath;
    }
}

// Zona horaria por defecto
date_default_timezone_set('America/Costa_Rica');
