<?php
declare(strict_types=1);

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

/**
 * TEST E2E FACTURA FE 4.4 (alineado a XmlFacturaBuilder + Hacienda v4.4)
 */

// Front controller de tu API AFE
$apiIndex = 'https://iscomer.islogi.com/public/index.php';

// API KEY REAL DEL CLIENTE
$apiKey   = 'islogi_fe_2025_f535ebaaec64ef54e1625b5b12dd2577';

// Consecutivo interno para esta prueba
$consecutivoInternoPrueba = 'FAC-TEST-V44-ACEPTA-01';

// Ambiente que usa tu API internamente
$ambiente = 'pruebas';

// Polling de estado Hacienda
$pollMaxIntentos = 8;
$pollIntervalSeg = 5;

/* ============================================================
 *  EMISOR (TU RUT + CERTIFICADO)
 * ============================================================ */

$EMISOR_CEDULA           = '206530483';
$EMISOR_TIPO_ID          = '01'; // Cédula física
$EMISOR_NOMBRE           = 'LEDIS ANTONIO OPORTA VIVAS';
$EMISOR_NOMBRE_COMERCIAL = 'Mercado Tico';

// Aguas Zarcas, San Carlos, Alajuela (ajusta si en ATV tienes algo distinto)
$EMISOR_PROVINCIA   = '2';   // Alajuela
$EMISOR_CANTON      = '10';  // San Carlos
$EMISOR_DISTRITO    = '04';  // Aguas Zarcas
$EMISOR_OTRAS_SENAS = 'Costa Rica, Alajuela, San Carlos, Aguas Zarcas';

$EMISOR_TEL_COD_PAIS = '506';
$EMISOR_TEL_NUMERO   = '83809606';
$EMISOR_CORREO       = 'contabilidad@mercadotico.com';

/* ============================================================
 *  ACTIVIDAD ECONÓMICA (DE TU RUT)
 * ============================================================ */

// IMPORTANTE: reemplaza 'XXXXXX' por el código EXACTO de ATV (6 dígitos sin puntos)
$CODIGO_ACTIVIDAD_EMISOR = 'XXXXXX';

/* ============================================================
 *  RECEPTOR: BIOAGROTEC S.A.
 * ============================================================ */

$RECEPTOR_TIPO_ID   = '02';          // Jurídica
$RECEPTOR_NUM_ID    = '3101774276';  // Bioagrotec
$RECEPTOR_NOMBRE    = 'BIOAGROTEC SOCIEDAD ANONIMA';
$RECEPTOR_CORREO    = 'mayafacturacr@gmail.com';
$RECEPTOR_TEL_PAIS  = '506';
$RECEPTOR_TEL_NUM   = '85669400';

// Estos deben coincidir EXACTO con lo que Tributación tiene para esa cédula.
// Mientras no lo sepas, puedes comentar el bloque 'ubicacion' en $data['receptor'].
$RECEPTOR_PROVINCIA   = '1';
$RECEPTOR_CANTON      = '01';
$RECEPTOR_DISTRITO    = '01';
$RECEPTOR_OTRAS_SENAS = 'Dirección según ATV de Bioagrotec';

/* ============================================================
 *  CABYS PARA LA LÍNEA (de tu factura real)
 * ============================================================ */

// Ejemplo: soporte y mantenimiento sitio web 1 año
$CODIGO_CABYS = '8316200000000';

/* ============================================================
 *  PAYLOAD FE 4.4
 * ============================================================ */

$data = [
    'tipo'                => 'FE',
    'consecutivo_interno' => $consecutivoInternoPrueba,
    'ambiente'            => $ambiente,

    'proveedor_sistemas'  => $EMISOR_CEDULA,

    'emisor' => [
        'nombre'                => $EMISOR_NOMBRE,
        'tipo_identificacion'   => $EMISOR_TIPO_ID,
        'numero_identificacion' => $EMISOR_CEDULA,
        'nombre_comercial'      => $EMISOR_NOMBRE_COMERCIAL,
        'ubicacion' => [
            'provincia'   => $EMISOR_PROVINCIA,
            'canton'      => $EMISOR_CANTON,
            'distrito'    => $EMISOR_DISTRITO,
            'otras_senas' => $EMISOR_OTRAS_SENAS,
        ],
        'telefono' => [
            'codigo_pais'  => $EMISOR_TEL_COD_PAIS,
            'num_telefono' => $EMISOR_TEL_NUMERO,
        ],
        'correo' => $EMISOR_CORREO,
    ],

    'receptor' => [
        'nombre'                => $RECEPTOR_NOMBRE,
        'tipo_identificacion'   => $RECEPTOR_TIPO_ID,
        'numero_identificacion' => $RECEPTOR_NUM_ID,
        // Si te sigue dando error -37, comenta este bloque completo de 'ubicacion'
        'ubicacion' => [
            'provincia'   => $RECEPTOR_PROVINCIA,
            'canton'      => $RECEPTOR_CANTON,
            'distrito'    => $RECEPTOR_DISTRITO,
            'otras_senas' => $RECEPTOR_OTRAS_SENAS,
        ],
        'telefono' => [
            'codigo_pais'  => $RECEPTOR_TEL_PAIS,
            'num_telefono' => $RECEPTOR_TEL_NUM,
        ],
        'correo' => $RECEPTOR_CORREO,
    ],

    'codigo_actividad_emisor' => $CODIGO_ACTIVIDAD_EMISOR,

    'condicion_venta' => '01', // Contado
    'medio_pago'      => '03', // Otros / según tu realidad

    'moneda'      => 'CRC',
    'tipo_cambio' => 1.00,

    // Una sola línea de servicio gravado al 13%
    'lineas' => [
        [
            'cantidad'        => 1,
            'unidad_medida'   => 'Sp',
            'detalle'         => 'Soporte y mantenimiento del sitio web durante 1 año',
            'precio_unitario' => 35400.00,
            'codigo_cabys'    => $CODIGO_CABYS,

            'descuento_monto'  => 0.0,
            'descuento_motivo' => 'Sin descuento',

            // Bloque impuesto que ahora sí entiende correctamente el XmlFacturaBuilder
            'impuesto' => [
                'codigo'           => '01',   // IVA
                'codigo_tarifa_iva'=> '08',   // Tarifa general 13% en v4.4
                'tarifa'           => 13.00,
            ],
        ],
    ],
];

/* ============================================================
 *  HELPER CURL + FLUJO
 * ============================================================ */

function call_api(string $url, string $method, string $apiKey, ?array $jsonBody = null): array
{
    $ch = curl_init($url);

    $headers = [
        'Accept: application/json',
        'X-API-KEY: ' . $apiKey,
    ];

    if ($jsonBody !== null) {
        $headers[] = 'Content-Type: application/json; charset=utf-8';
        $payload   = json_encode($jsonBody, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    }

    if (strtoupper($method) === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
    } else {
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    }

    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HEADER         => false,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_HTTPHEADER     => $headers,
        CURLOPT_TIMEOUT        => 60,
    ]);

    $raw  = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($raw === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return [
            'http_status' => 0,
            'raw'         => null,
            'json'        => null,
            'curl_error'  => $error,
        ];
    }

    curl_close($ch);

    $json = null;
    if ($raw !== '' && $raw !== null) {
        $json = json_decode($raw, true);
    }

    return [
        'http_status' => $http,
        'raw'         => $raw,
        'json'        => $json,
        'curl_error'  => null,
    ];
}

// ==== FLUJO E2E (crear, enviar, consultar) ====

$resultado = [
    'info'  => [
        'api_index'           => $apiIndex,
        'api_key_cliente'     => $apiKey,
        'consecutivo_interno' => $consecutivoInternoPrueba,
        'ambiente'            => $ambiente,
        'poll_max_intentos'   => $pollMaxIntentos,
        'poll_interval_seg'   => $pollIntervalSeg,
    ],
    'pasos' => [],
];

// 1) CREAR DOCUMENTO
$urlCrear  = $apiIndex . '?r=api/v1/documentos';
$respCrear = call_api($urlCrear, 'POST', $apiKey, $data);
$resultado['pasos']['crear_documento'] = $respCrear;

if ($respCrear['curl_error'] !== null ||
    $respCrear['http_status'] !== 201 ||
    empty($respCrear['json']['ok'])) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$documentoId = (int)$respCrear['json']['documento_id'];

// 2) ENVIAR A HACIENDA
$urlEnviar  = $apiIndex . '?r=api/v1/documentos/enviar';
$respEnviar = call_api($urlEnviar, 'POST', $apiKey, [
    'documento_id' => $documentoId,
]);
$resultado['pasos']['enviar_hacienda'] = $respEnviar;

if ($respEnviar['curl_error'] !== null) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

// 3) POLL ESTADO
$urlEstado = $apiIndex . '?r=api/v1/documentos/estado&id=' . urlencode((string)$documentoId);
$intentos  = 0;
$historial = [];

while ($intentos < $pollMaxIntentos) {
    $intentos++;

    $respEstado = call_api($urlEstado, 'GET', $apiKey, null);
    $historial[] = $respEstado;

    if ($respEstado['curl_error'] !== null) {
        break;
    }

    $json = $respEstado['json'] ?? null;
    if (is_array($json) && !empty($json['ok']) && array_key_exists('hacienda_estado', $json)) {
        $estadoHacienda = $json['hacienda_estado'];

        if ($estadoHacienda !== null &&
            !in_array($estadoHacienda, ['procesando', 'enviado'], true)) {
            break;
        }
    }

    sleep($pollIntervalSeg);
}

$resultado['pasos']['consultar_estado'] = [
    'intentos_realizados' => $intentos,
    'historial'           => $historial,
];

header('Content-Type: application/json; charset=utf-8');
echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
