<?php

namespace App\HttpClients\Clients;

use App\HttpClients\Contracts\TipoCambioClient;
use App\HttpClients\DTOs\TipoCambioResponse;
use Illuminate\Support\Facades\Http;

class BCCRTipoCambioClient implements TipoCambioClient
{
    private $apiKey;

    public function __construct()
    {
        $this->apiKey = config('services.bccr.ssde.key');
    }

    public function getActual(): TipoCambioResponse
    {
        $date = new \DateTimeImmutable('today', new \DateTimeZone('America/Costa_Rica'));

        $response = Http::withToken($this->apiKey)
            ->withOptions([
                'verify' => false
            ])
            ->acceptJson()
            ->throw()
            ->get('https://apim.bccr.fi.cr/sddE/api/Bccr.Ge.SDDE.Publico.Indicadores.API/cuadro/1/series', [
                'idioma' => 'ES',
                'fechaInicio' => $date->format('Y/m/d'),
                'fechaFin' => $date->format('Y/m/d'),
            ]);
        
        $data = json_decode((string) $response, true); 
        if (json_last_error() !== JSON_ERROR_NONE) { 
            throw new \Exception("No valid data from BCCR");
        }

        return new TipoCambioResponse(
            compra: $this->getValorDatoPorPeriodo($data, "317"),
            venta: $this->getValorDatoPorPeriodo($data, "318"), 
            fecha: $date,
        );
    }

    protected function getValorDatoPorPeriodo(array $data, string $codigoIndicador): ?float 
    {
        if (!isset($data['datos'][0]['indicadores'])) {
            return null;
        }

        foreach ($data['datos'][0]['indicadores'] as $indicador) {
            if ($indicador['codigoIndicador'] === $codigoIndicador) {
                return $indicador['series'][0]['valorDatoPorPeriodo'] ?? null;
            }
        }

        return null;
    }

}
