<?php

namespace App\HttpClients\Factories;

use App\HttpClients\Contracts\TipoCambioClient;
use App\HttpClients\Clients\BCCRTipoCambioClient;

use InvalidArgumentException;

class TipoCambioClientFactory
{
    public static function make(string $provider): TipoCambioClient
    {
        return match ($provider) {
            'bccr' => new BCCRTipoCambioClient(),
            default => throw new InvalidArgumentException("Unknown provider: {$provider}")
        };
    }
}
