<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

use Illuminate\Queue\Middleware\WithoutOverlapping;

class ConsultarDocumentoJob implements ShouldQueue
{
    use Queueable;

    public string $clave;

    public function __construct(string $clave) 
    {
        $this->clave = $clave; 
    }

    public function middleware(): array
    {
        return [new WithoutOverlapping($this->clave)];
    }

    public function handle(): void
    {
        $response = $service->consultClave($this->clave);

        DB::table('facturas')->where('clave', $this->clave)->update([ 'estado' => $response['estado'] ?? 'pendiente', 'mensaje' => $response['mensaje'] ?? null, 'updated_at' => now(), ]);
    }

    
}
