<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sucursal extends Model
{
    protected $table = 'sucursales';

    protected $fillable = [
        'cliente_id',
        'cod_actividad',
        'provincia',
        'canton',
        'distrito',
        'sennas',
        'telefono',
        'correo',
        'mh_ambiente'
    ];

    public static function getSecuenciaColumn(string $tipoDocumento): string
    {
        return match (strtoupper($tipoDocumento)) 
        {
            'FE' => 'consec_fe',
            'TE' => 'consec_te',
        };
    }

    public function getConsecutivo(string $tipoDocumento): int
    {
        $column = self::getSecuenciaColumn($tipoDocumento);
        return (int) ($this->$column ?? 0);
    }

    public function getNextConsecutivo(string $tipoDocumento): int
    {
        return $this->getConsecutivo($tipoDocumento) + 1;
    }

    public function formatNumeracion(int $numero): string
    {
        $formatted = str_pad($numero, 10, '0', STR_PAD_LEFT);
        return $formatted;
    }
}