<?php

namespace App\Services;

use Symfony\Component\Process\Process;
use Symfony\Component\Process\Exception\ProcessFailedException;

class CertificadosService 
{
    public static function procesarCertificado($cert, $pin) 
    {
        try 
        {
            $rt = self::getRandomHexSubstring();

            $tempFilePath       = storage_path("app/tmp/temp_cert_{$rt}.p12");
            $decryptFilePath    = storage_path("app/tmp/key_decrypt_{$rt}.tmp");
            $reencryptFilePath  = storage_path("app/tmp/output_cert_{$rt}.p12");

            if (!is_dir(storage_path('app/tmp'))) {
                mkdir(storage_path('app/tmp'), 0755, true);
            }

            file_put_contents($tempFilePath, $cert);

            $process = new Process([
                'openssl', 'pkcs12',
                '-legacy',
                '-passin', "pass:{$pin}",
                '-in', $tempFilePath,
                '-nodes',
                '-out', $decryptFilePath,
            ]);
            $process->run();

            if (!$process->isSuccessful()) {
                throw new ProcessFailedException($process);
            }

            $process = new Process([
                'openssl', 'pkcs12',
                '-passout', "pass:{$pin}",
                '-in', $decryptFilePath,
                '-export',
                '-out', $reencryptFilePath,
            ]);
            $process->run();

            if (!$process->isSuccessful()) {
                throw new ProcessFailedException($process);
            }

            $processedFile = file_get_contents($reencryptFilePath);
            return $processedFile;

        } catch (\Throwable $e) {
            throw new \Exception("No se ha podido procesar el certificado" . $e->getMessage());
        } finally {
            foreach ([$tempFilePath, $decryptFilePath, $reencryptFilePath] as $file) 
            { 
                if (file_exists($file)) 
                { 
                    @unlink($file); 
                } 
            }
        }
    }

    public static function getRandomHexSubstring($n = 12) 
    {
        $randomBinary = random_bytes($n / 2); 
        $hexString = bin2hex($randomBinary);
        return substr($hexString, 0, $n);
    }
}