<?php

namespace App\Http\Requests\Documents;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\DB;

class UpdateSucursal extends FormRequest
{
    public function authorize(): bool
    {
        $cliente = $this->attributes->get('cliente');
        $sucursalId = $this->route('sucursalId');

        return DB::table('sucursales')
            ->where('id', $sucursalId)
            ->where('cliente_id', $cliente->id)
            ->exists();
    }

    public function rules(): array
    {
        return [
            'nombre_comercial' => ['nullable', 'string', 'max:100'],
            'cod_actividad' => ['nullable', 'string', 'size:6'],
            'provincia' => ['nullable', 'numeric', 'digits:1', 'min:1'],
            'canton' => ['nullable', 'numeric', 'digits_between:1,2', 'min:1'],
            'distrito' => ['nullable', 'numeric', 'digits_between:1,2', 'min:1'],
            'sennas' => ['nullable', 'string', 'max:100'],
            'telefono' => ['nullable', 'string'],
            'correo' => ['nullable', 'email'],
        ];
    }
}