<?php

namespace App\Data;

use Spatie\LaravelData\Data;

class ElectronicDocument extends Data
{
    public function __construct(
        public ?string $nombre_comercial,
        public ?string $proveedor_sistema,
        public ?string $clave,
        public string $cod_act_economica_emisor,
        public ?string $cod_act_economica_receptor,
        public ?string $numero_consecutivo,
        public ?string $fecha_emision,

        public ?string $moneda = 'CRC',
        public float $tipo_cambio,

        public PersonData $emisor,

        public ?PersonData $receptor,
        
        /** @var LineaItemData[] */
        public array $lineas,

        public array $resumen,

        public string $condicion_venta,
        public ?string $condicion_venta_otros = null,
        public string $plazo_credito = "0",
        
        public array $medio_pago,
        public array $desglose_impuestos,
        public ?array $info_referencia
    ) {}

    public function finalize(string $clave, string $consecutivo, string $fecha): self
    {
        return new self(
            $this->nombre_comercial,
            $this->proveedor_sistema,
            $clave,
            $this->cod_act_economica_emisor,
            $this->cod_act_economica_receptor,
            $consecutivo,
            $fecha,
            $this->moneda,
            $this->tipo_cambio,
            $this->emisor,
            $this->receptor,
            $this->lineas,
            $this->resumen,
            $this->condicion_venta,
            $this->condicion_venta_otros,
            $this->plazo_credito,
            $this->medio_pago,
            $this->desglose_impuestos,
            $this->info_referencia
        );
    }
}