<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request; 
use Closure; 
class InjectBranchContext 
{
    public function handle(Request $request, Closure $next)
    {
        $apiKey = $request->header('X-API-KEY');

        if(!$apiKey) { 
            return response()->json(['error' => 'API key missing'], 401); 
        }

        $record = DB::table('api_keys')
            ->join('sucursales', 'api_keys.sucursal_id', '=', 'sucursales.id')
            ->join('clientes', 'sucursales.cliente_id', '=', 'clientes.id')
            ->join('mh_credenciales', function ($join) { 
                $join->on('mh_credenciales.client_id', '=', 'clientes.id') 
                    ->on('mh_credenciales.mh_environment', '=', 'sucursales.mh_ambiente'); 
            })
            ->where('api_keys.api_key', $apiKey)
            ->select(
                'sucursales.id as sucursal_id', 
                'sucursales.cod_sucursal as sucursal_code', 
                'sucursales.cod_terminal as sucursal_terminal',
                'sucursales.provincia',
                'sucursales.canton',
                'sucursales.distrito',
                'sucursales.sennas',
                'sucursales.correo',
                'sucursales.nombre_comercial',
                'sucursales.cod_actividad',
                'clientes.nombre', 
                'clientes.tipo_identificacion',
                'clientes.identificacion',  
                'mh_credenciales.*'
            )
            ->first();

        if(!$record) 
        {
            return response()->json([
                'error' => 'Invalid API key or missing related data'
            ], 401); 
        }

        $request->merge([
            'cod_act_economica_emisor' => $record->cod_actividad,
            'emisor' => [
                'nombre' => $record->nombre,
                'tipo_identificacion' => $record->tipo_identificacion,
                'numero_identificacion' => $record->identificacion,
                'ubicacion' => [
                    'provincia' => $record->provincia,
                    'canton' => $record->canton,
                    'distrito' => $record->distrito,
                    'sennas' => $record->sennas
                ],
                'correo' => $record->correo,
            ]
        ]);

        $request->attributes->set('mh_credenciales', [
            "sucursal_id" => $record->sucursal_id,
            "sucursal_code" => $record->sucursal_code,
            "sucursal_terminal" => $record->sucursal_terminal,
            "nombre_comercial" => $record->nombre_comercial,
            "actividad_economica" => $record->cod_actividad,
            "isSandbox" => $record->mh_environment == "sandbox",
            "username" => $record->mh_username,
            "password" => $record->mh_password,
            "cert_path" => $record->cert_path,
            "cert_pin" => $record->cert_pin
        ]);

        return $next($request);
    }
}