<?php

namespace App\Http\Requests\Documents;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\DB;

class CreateSucursal extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'nombre_comercial' => ['nullable', 'string', 'max:100'],
            'cod_actividad' => ['required', 'string', 'size:6'],
            'cod_sucursal' => ['required', 'numeric', 'digits_between:1,3', "min:1"],
            'cod_terminal' => ['required', 'numeric','digits_between:1,5', "min:1"],
            'provincia' => ['required', 'numeric', 'digits:1', 'min:1'],
            'canton' => ['required', 'numeric', 'digits_between:1,2', 'min:1'],
            'distrito' => ['required', 'numeric', 'digits_between:1,2', 'min:1'],
            'sennas' => ['required', 'string', 'max:100'],
            'telefono' => ['nullable', 'string'],
            'correo' => ['required', 'email'],
            'consec_fe' => ['required', 'numeric', 'min:1'],
            'consec_te' => ['required', 'numeric', 'min:1'],
            'consec_nc' => ['required', 'numeric', 'min:1'],
            'consec_nd' => ['required', 'numeric', 'min:1'],
            'mh_ambiente' => ['required', 'in:sandbox,production'],
        ];
    }
}