<?php

namespace App\HttpClients\Factories;

use App\HttpClients\Contracts\TipoCambioClient;
use App\HttpClients\Clients\BCCRTipoCambioClient;
use App\HttpClients\Clients\HaciendaTipoCambioClient;
use InvalidArgumentException;

class TipoCambioClientFactory
{
    public static function make(string $provider): TipoCambioClient
    {
        return match ($provider) {
            'hacienda' => new HaciendaTipoCambioClient(),
            'bccr'     => new BCCRTipoCambioClient(),
            default    => throw new InvalidArgumentException("Unknown provider: {$provider}")
        };
    }
}
