<?php

namespace App\Services\ElectronicBilling\Builders;

use App\Services\ElectronicBilling\Builders\AbstractXmlBuilder;

class NotaCreditoBuilder extends AbstractXmlBuilder
{
    protected function getRootNodeName(): string
    {
        return 'NotaCreditoElectronica';
    }

    protected function getNamespaceUrl(): string
    {
        return 'https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/notaCreditoElectronica';
    }

    protected function getSchemaUrl(): string
    {
        return 'https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/notaCreditoElectronica.xsd';
    }

    protected function getBuildSteps(): array { 
        return [ 
            'buildHeader', 
            'buildIssuer', 
            'buildReceiver', 
            'buildConditionOfSale', 
            'buildDetail', 
            'buildSummary',
            'buildReference'
        ]; 
    }

    protected function shouldBuildReceptor(): bool 
    {
        return isset($this->data->receptor);
    }

    protected function buildReference()
    {
        $container = $this->addChild($this->root, 'InformacionReferencia');

        $this->addText("TipoDocIR", $this->data->info_referencia['tipo_doc'], $container);
        $this->addText("Numero",$this->data->info_referencia['clave'], $container);
        $this->addText("FechaEmisionIR",$this->data->info_referencia['fecha_emision'], $container);
        $this->addText("Codigo",$this->data->info_referencia['codigo'], $container);
        $this->addText("Razon",$this->data->info_referencia['razon'], $container);
    }

}