<?php

namespace App\Services\ElectronicBilling\Builders;

use App\Services\ElectronicBilling\Builders\AbstractXmlBuilder;
use DOMElement;

class TiqueteElectronicoBuilder extends AbstractXmlBuilder
{
    protected function getRootNodeName(): string
    {
        return 'TiqueteElectronico';
    }

    protected function getNamespaceUrl(): string
    {
        return 'https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/tiqueteElectronico';
    }

    protected function getSchemaUrl(): string
    {
        return 'https://cdn.comprobanteselectronicos.go.cr/xml-schemas/v4.4/tiqueteElectronico.xsd';
    }

    protected function getBuildSteps(): array { 
        return [ 
            'buildHeader', 
            'buildIssuer', 
            'buildReceiver', 
            'buildConditionOfSale', 
            'buildDetail', 
            'buildSummary',
            'buildOtros'
        ]; 
    }

    protected function shouldBuildReceptor(): bool 
    {
        return false;
    }
}