<?php

namespace App\Utils;

class SucursalUtil 
{
    public static function normalizeData(array $data): array
    {
        if (isset($data['cod_sucursal'])) {
            $num = \intval(value: $data['cod_sucursal']);
            $data['cod_sucursal'] = str_pad((string)$num, 3, "0", STR_PAD_LEFT);
        }

        if (isset($data['cod_terminal'])) {
            $num = \intval($data['cod_terminal']);
            $data['cod_terminal'] = str_pad((string)$num, 5, "0", STR_PAD_LEFT);
        }

        if (isset($data['canton'])) {
            $num = \intval($data['canton']);
            $data['canton'] = str_pad((string)$num, 2, "0", STR_PAD_LEFT);
        }

        if (isset($data['distrito'])) {
            $num = \intval($data['distrito']);
            $data['distrito'] = str_pad((string)$num, 2, "0", STR_PAD_LEFT);
        }

        return $data;
    }

    public static function generarApiKey(): string
    {
        $year = date('Y');
        $random = bin2hex(random_bytes(16));
        return "islogi_fe_{$year}_{$random}";
    }
}