<?php

use Illuminate\Foundation\Application;
use Illuminate\Validation\ValidationException;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Routing\Exception\RouteNotFoundException;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        api: __DIR__.'/../routes/api.php',
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        //
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        
        $exceptions->shouldRenderJsonWhen(fn() => true);

        $exceptions->render(fn (ValidationException $exception) => response()->json([
            'success' => false,
            'message' => $exception->errors(),
            'data' => [],
        ], Response::HTTP_UNPROCESSABLE_ENTITY));

        $exceptions->render(fn(NotFoundHttpException|RouteNotFoundException $e) => response()->json([
            'message' => 'The endpoint you are looking for is not found.',
        ], 404));

       // $exceptions->render(fn (Throwable $throwable) => response()->json([
        //    'success' => false,
          //  'message' => $throwable->getMessage(),
        //    'data' => [],
    //    ], Response::HTTP_INTERNAL_SERVER_ERROR));


    })->create();
