<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;

class BasicAuthCliente
{
    public function handle(Request $request, Closure $next): Response
    {
        $username = $request->getUser();
        $password = $request->getPassword();

        if (! $username || ! $password) {
            return response()->json([
                'error' => 'Unauthorized'
            ], 401); 
        }

        $cliente = DB::table('clientes')
            ->where('identificacion', $username)
            ->where('pin', $password)
            ->first();

        if (!$cliente) {
            return response()->json([
                'error' => 'Unauthorized'
            ], 401); 
        }

        $request->attributes->set('cliente', $cliente);

        return $next($request);
    }
}
