<?php

namespace App\HttpClients\DTOs\Hacienda;

use Spatie\LaravelData\Data;

class TokenResponse extends Data
{
    public string $access_token;
    public int $expires_in;

    public function expiresAt(): int 
    { 
        return time() + $this->expires_in;
    }
    
    public function isExpired(): bool 
    {
        return time() >= $this->expiresAt();
    }

}
