<?php

namespace App\Jobs;

use App\HttpClients\DTOs\Hacienda\DocStatusResponse;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

use Illuminate\Queue\Middleware\WithoutOverlapping;
use Illuminate\Support\Facades\DB;

class ProcessWebhookHaciendaJob implements ShouldQueue
{
    use Queueable;

    public function __construct(
        protected string $clave,
        protected DocStatusResponse $data
    )
    {}

    public function middleware(): array
    {
        return [
            new WithoutOverlapping($this->clave)
        ];
    }

    public function handle(): void
    {
        DB::table('documentos')
            ->where('clave', $this->clave)
            ->whereIn('estado', ['enviado', 'pendiente'])
            ->update([
                'estado'        => $this->data->response_xml ? 'finalizado' : 'pendiente',
                'xml_respuesta' => $this->data->response_xml ?? null,
                'respuesta_hacienda' => $this->data->status ?? null,
            ]);
    }
}
